/************************************************************************
 * @file: AudioHelper.h
 *
 * @version: 0.1
 *
 * @description: This header file contains helper functions ,converting frames to
 * time, converting time to frames, Runtime PCM dump enabling and disabling.
 * The Helper class is in herited by Backend, So both application and RTA Backend
 * can use these helper functions.
 *
 * @authors: Jens Lorenz, jlorenz@de.adit-jv.com 2015
 *           Vijay Palaniswamy, vijay.palaniswamy@in.bosch.com 2015
 *
 * @copyright (c) 2015 Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#ifndef _ADIT_UTILITY_AUDIOHELPER_H_
#define _ADIT_UTILITY_AUDIOHELPER_H_


namespace adit
{

namespace utility
{

namespace audio
{

    /* Helper functions */

    /* Function for calculating period in frames from given time in milliseconds
     * @param[IN] rate The sample rate of the stream
     * @param[IN] ms   Period in frames to be calculated for this milliseconds
     * @return Period in frames for the given time in milliseconds
     */
    inline uint64_t convertMsToFrames(uint32_t rate,uint32_t ms)
    {
        return ((static_cast<uint64_t>(rate) * ms) / 1000);
    }

    /* Function for for calculating Period in time [milliseconds] from given frames
     * @param[IN] rate   The sample rate of the stream
     * @param[IN] frames Period in time [milliseconds] to be calculated for this frames
     * @return Period in time [milliseconds] for the given frames
     */
    inline double convertFramesToMs(uint32_t rate,uint64_t frames)
    {
        return static_cast<double>((frames * 1000) / static_cast<double>(rate));
    }


} /* namespace audio */

} /* namespace utility */

} /* namespace adit */

#endif /* _ADIT_UTILITY_AUDIOHELPER_H_ */
